/*******************************************************************************
* File Name: coderun.h  
* Version 1.90
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_coderun_H) /* Pins coderun_H */
#define CY_PINS_coderun_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "coderun_aliases.h"

/* Check to see if required defines such as CY_PSOC5A are available */
/* They are defined starting with cy_boot v3.0 */
#if !defined (CY_PSOC5A)
    #error Component cy_pins_v1_90 requires cy_boot v3.0 or later
#endif /* (CY_PSOC5A) */

/* APIs are not generated for P15[7:6] */
#if !(CY_PSOC5A &&\
	 coderun__PORT == 15 && ((coderun__MASK & 0xC0) != 0))


/***************************************
*        Function Prototypes             
***************************************/    

void    coderun_Write(uint8 value) ;
void    coderun_SetDriveMode(uint8 mode) ;
uint8   coderun_ReadDataReg(void) ;
uint8   coderun_Read(void) ;
uint8   coderun_ClearInterrupt(void) ;


/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define coderun_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define coderun_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define coderun_DM_RES_UP          PIN_DM_RES_UP
#define coderun_DM_RES_DWN         PIN_DM_RES_DWN
#define coderun_DM_OD_LO           PIN_DM_OD_LO
#define coderun_DM_OD_HI           PIN_DM_OD_HI
#define coderun_DM_STRONG          PIN_DM_STRONG
#define coderun_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define coderun_MASK               coderun__MASK
#define coderun_SHIFT              coderun__SHIFT
#define coderun_WIDTH              1u


/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define coderun_PS                     (* (reg8 *) coderun__PS)
/* Data Register */
#define coderun_DR                     (* (reg8 *) coderun__DR)
/* Port Number */
#define coderun_PRT_NUM                (* (reg8 *) coderun__PRT) 
/* Connect to Analog Globals */                                                  
#define coderun_AG                     (* (reg8 *) coderun__AG)                       
/* Analog MUX bux enable */
#define coderun_AMUX                   (* (reg8 *) coderun__AMUX) 
/* Bidirectional Enable */                                                        
#define coderun_BIE                    (* (reg8 *) coderun__BIE)
/* Bit-mask for Aliased Register Access */
#define coderun_BIT_MASK               (* (reg8 *) coderun__BIT_MASK)
/* Bypass Enable */
#define coderun_BYP                    (* (reg8 *) coderun__BYP)
/* Port wide control signals */                                                   
#define coderun_CTL                    (* (reg8 *) coderun__CTL)
/* Drive Modes */
#define coderun_DM0                    (* (reg8 *) coderun__DM0) 
#define coderun_DM1                    (* (reg8 *) coderun__DM1)
#define coderun_DM2                    (* (reg8 *) coderun__DM2) 
/* Input Buffer Disable Override */
#define coderun_INP_DIS                (* (reg8 *) coderun__INP_DIS)
/* LCD Common or Segment Drive */
#define coderun_LCD_COM_SEG            (* (reg8 *) coderun__LCD_COM_SEG)
/* Enable Segment LCD */
#define coderun_LCD_EN                 (* (reg8 *) coderun__LCD_EN)
/* Slew Rate Control */
#define coderun_SLW                    (* (reg8 *) coderun__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define coderun_PRTDSI__CAPS_SEL       (* (reg8 *) coderun__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define coderun_PRTDSI__DBL_SYNC_IN    (* (reg8 *) coderun__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define coderun_PRTDSI__OE_SEL0        (* (reg8 *) coderun__PRTDSI__OE_SEL0) 
#define coderun_PRTDSI__OE_SEL1        (* (reg8 *) coderun__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define coderun_PRTDSI__OUT_SEL0       (* (reg8 *) coderun__PRTDSI__OUT_SEL0) 
#define coderun_PRTDSI__OUT_SEL1       (* (reg8 *) coderun__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define coderun_PRTDSI__SYNC_OUT       (* (reg8 *) coderun__PRTDSI__SYNC_OUT) 


#if defined(coderun__INTSTAT)  /* Interrupt Registers */

    #define coderun_INTSTAT                (* (reg8 *) coderun__INTSTAT)
    #define coderun_SNAP                   (* (reg8 *) coderun__SNAP)

#endif /* Interrupt Registers */

#endif /* CY_PSOC5A... */

#endif /*  CY_PINS_coderun_H */


/* [] END OF FILE */
