/*******************************************************************************
* File Name: h2.h  
* Version 1.90
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_h2_H) /* Pins h2_H */
#define CY_PINS_h2_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "h2_aliases.h"

/* Check to see if required defines such as CY_PSOC5A are available */
/* They are defined starting with cy_boot v3.0 */
#if !defined (CY_PSOC5A)
    #error Component cy_pins_v1_90 requires cy_boot v3.0 or later
#endif /* (CY_PSOC5A) */

/* APIs are not generated for P15[7:6] */
#if !(CY_PSOC5A &&\
	 h2__PORT == 15 && ((h2__MASK & 0xC0) != 0))


/***************************************
*        Function Prototypes             
***************************************/    

void    h2_Write(uint8 value) ;
void    h2_SetDriveMode(uint8 mode) ;
uint8   h2_ReadDataReg(void) ;
uint8   h2_Read(void) ;
uint8   h2_ClearInterrupt(void) ;


/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define h2_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define h2_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define h2_DM_RES_UP          PIN_DM_RES_UP
#define h2_DM_RES_DWN         PIN_DM_RES_DWN
#define h2_DM_OD_LO           PIN_DM_OD_LO
#define h2_DM_OD_HI           PIN_DM_OD_HI
#define h2_DM_STRONG          PIN_DM_STRONG
#define h2_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define h2_MASK               h2__MASK
#define h2_SHIFT              h2__SHIFT
#define h2_WIDTH              1u


/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define h2_PS                     (* (reg8 *) h2__PS)
/* Data Register */
#define h2_DR                     (* (reg8 *) h2__DR)
/* Port Number */
#define h2_PRT_NUM                (* (reg8 *) h2__PRT) 
/* Connect to Analog Globals */                                                  
#define h2_AG                     (* (reg8 *) h2__AG)                       
/* Analog MUX bux enable */
#define h2_AMUX                   (* (reg8 *) h2__AMUX) 
/* Bidirectional Enable */                                                        
#define h2_BIE                    (* (reg8 *) h2__BIE)
/* Bit-mask for Aliased Register Access */
#define h2_BIT_MASK               (* (reg8 *) h2__BIT_MASK)
/* Bypass Enable */
#define h2_BYP                    (* (reg8 *) h2__BYP)
/* Port wide control signals */                                                   
#define h2_CTL                    (* (reg8 *) h2__CTL)
/* Drive Modes */
#define h2_DM0                    (* (reg8 *) h2__DM0) 
#define h2_DM1                    (* (reg8 *) h2__DM1)
#define h2_DM2                    (* (reg8 *) h2__DM2) 
/* Input Buffer Disable Override */
#define h2_INP_DIS                (* (reg8 *) h2__INP_DIS)
/* LCD Common or Segment Drive */
#define h2_LCD_COM_SEG            (* (reg8 *) h2__LCD_COM_SEG)
/* Enable Segment LCD */
#define h2_LCD_EN                 (* (reg8 *) h2__LCD_EN)
/* Slew Rate Control */
#define h2_SLW                    (* (reg8 *) h2__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define h2_PRTDSI__CAPS_SEL       (* (reg8 *) h2__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define h2_PRTDSI__DBL_SYNC_IN    (* (reg8 *) h2__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define h2_PRTDSI__OE_SEL0        (* (reg8 *) h2__PRTDSI__OE_SEL0) 
#define h2_PRTDSI__OE_SEL1        (* (reg8 *) h2__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define h2_PRTDSI__OUT_SEL0       (* (reg8 *) h2__PRTDSI__OUT_SEL0) 
#define h2_PRTDSI__OUT_SEL1       (* (reg8 *) h2__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define h2_PRTDSI__SYNC_OUT       (* (reg8 *) h2__PRTDSI__SYNC_OUT) 


#if defined(h2__INTSTAT)  /* Interrupt Registers */

    #define h2_INTSTAT                (* (reg8 *) h2__INTSTAT)
    #define h2_SNAP                   (* (reg8 *) h2__SNAP)

#endif /* Interrupt Registers */

#endif /* CY_PSOC5A... */

#endif /*  CY_PINS_h2_H */


/* [] END OF FILE */
