/*******************************************************************************
* File Name: heartbeat.h  
* Version 1.90
*
* Description:
*  This file containts Control Register function prototypes and register defines
*
* Note:
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(CY_PINS_heartbeat_H) /* Pins heartbeat_H */
#define CY_PINS_heartbeat_H

#include "cytypes.h"
#include "cyfitter.h"
#include "cypins.h"
#include "heartbeat_aliases.h"

/* Check to see if required defines such as CY_PSOC5A are available */
/* They are defined starting with cy_boot v3.0 */
#if !defined (CY_PSOC5A)
    #error Component cy_pins_v1_90 requires cy_boot v3.0 or later
#endif /* (CY_PSOC5A) */

/* APIs are not generated for P15[7:6] */
#if !(CY_PSOC5A &&\
	 heartbeat__PORT == 15 && ((heartbeat__MASK & 0xC0) != 0))


/***************************************
*        Function Prototypes             
***************************************/    

void    heartbeat_Write(uint8 value) ;
void    heartbeat_SetDriveMode(uint8 mode) ;
uint8   heartbeat_ReadDataReg(void) ;
uint8   heartbeat_Read(void) ;
uint8   heartbeat_ClearInterrupt(void) ;


/***************************************
*           API Constants        
***************************************/

/* Drive Modes */
#define heartbeat_DM_ALG_HIZ         PIN_DM_ALG_HIZ
#define heartbeat_DM_DIG_HIZ         PIN_DM_DIG_HIZ
#define heartbeat_DM_RES_UP          PIN_DM_RES_UP
#define heartbeat_DM_RES_DWN         PIN_DM_RES_DWN
#define heartbeat_DM_OD_LO           PIN_DM_OD_LO
#define heartbeat_DM_OD_HI           PIN_DM_OD_HI
#define heartbeat_DM_STRONG          PIN_DM_STRONG
#define heartbeat_DM_RES_UPDWN       PIN_DM_RES_UPDWN

/* Digital Port Constants */
#define heartbeat_MASK               heartbeat__MASK
#define heartbeat_SHIFT              heartbeat__SHIFT
#define heartbeat_WIDTH              1u


/***************************************
*             Registers        
***************************************/

/* Main Port Registers */
/* Pin State */
#define heartbeat_PS                     (* (reg8 *) heartbeat__PS)
/* Data Register */
#define heartbeat_DR                     (* (reg8 *) heartbeat__DR)
/* Port Number */
#define heartbeat_PRT_NUM                (* (reg8 *) heartbeat__PRT) 
/* Connect to Analog Globals */                                                  
#define heartbeat_AG                     (* (reg8 *) heartbeat__AG)                       
/* Analog MUX bux enable */
#define heartbeat_AMUX                   (* (reg8 *) heartbeat__AMUX) 
/* Bidirectional Enable */                                                        
#define heartbeat_BIE                    (* (reg8 *) heartbeat__BIE)
/* Bit-mask for Aliased Register Access */
#define heartbeat_BIT_MASK               (* (reg8 *) heartbeat__BIT_MASK)
/* Bypass Enable */
#define heartbeat_BYP                    (* (reg8 *) heartbeat__BYP)
/* Port wide control signals */                                                   
#define heartbeat_CTL                    (* (reg8 *) heartbeat__CTL)
/* Drive Modes */
#define heartbeat_DM0                    (* (reg8 *) heartbeat__DM0) 
#define heartbeat_DM1                    (* (reg8 *) heartbeat__DM1)
#define heartbeat_DM2                    (* (reg8 *) heartbeat__DM2) 
/* Input Buffer Disable Override */
#define heartbeat_INP_DIS                (* (reg8 *) heartbeat__INP_DIS)
/* LCD Common or Segment Drive */
#define heartbeat_LCD_COM_SEG            (* (reg8 *) heartbeat__LCD_COM_SEG)
/* Enable Segment LCD */
#define heartbeat_LCD_EN                 (* (reg8 *) heartbeat__LCD_EN)
/* Slew Rate Control */
#define heartbeat_SLW                    (* (reg8 *) heartbeat__SLW)

/* DSI Port Registers */
/* Global DSI Select Register */
#define heartbeat_PRTDSI__CAPS_SEL       (* (reg8 *) heartbeat__PRTDSI__CAPS_SEL) 
/* Double Sync Enable */
#define heartbeat_PRTDSI__DBL_SYNC_IN    (* (reg8 *) heartbeat__PRTDSI__DBL_SYNC_IN) 
/* Output Enable Select Drive Strength */
#define heartbeat_PRTDSI__OE_SEL0        (* (reg8 *) heartbeat__PRTDSI__OE_SEL0) 
#define heartbeat_PRTDSI__OE_SEL1        (* (reg8 *) heartbeat__PRTDSI__OE_SEL1) 
/* Port Pin Output Select Registers */
#define heartbeat_PRTDSI__OUT_SEL0       (* (reg8 *) heartbeat__PRTDSI__OUT_SEL0) 
#define heartbeat_PRTDSI__OUT_SEL1       (* (reg8 *) heartbeat__PRTDSI__OUT_SEL1) 
/* Sync Output Enable Registers */
#define heartbeat_PRTDSI__SYNC_OUT       (* (reg8 *) heartbeat__PRTDSI__SYNC_OUT) 


#if defined(heartbeat__INTSTAT)  /* Interrupt Registers */

    #define heartbeat_INTSTAT                (* (reg8 *) heartbeat__INTSTAT)
    #define heartbeat_SNAP                   (* (reg8 *) heartbeat__SNAP)

#endif /* Interrupt Registers */

#endif /* CY_PSOC5A... */

#endif /*  CY_PINS_heartbeat_H */


/* [] END OF FILE */
