/* =============================================================================
 *
 * App_Defs.h
 *
 * This file contains general defines for the demos (e.g. to control the LCD,
 * CapSense, switches and so on).
 *
 * v1.0	YFS	Initial release.
 *
 * =============================================================================
*/

/*
* Copyright (2014), Cypress Semiconductor Corporation. All Rights Reserved.
*
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH 
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the 
* materials described herein. Cypress does not assume any liability arising out 
* of the application or use of any product or circuit described herein. Cypress 
* does not authorize its products for use as critical components in life-support 
* systems where a malfunction or failure may reasonably be expected to result in 
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of 
* such use and in doing so indemnifies Cypress against all charges. 
*
* Use of this Software may be limited by and subject to the applicable Cypress
* software license agreement. 
*/

/*
LCD defines
*/

/* Useful defines for the LCD - used to scroll text across the screen */
#define MAX_MSG_LEN			(150)
#define LCD_WIDTH			(16)
#define SIXTEENSPACES		("                ")

/* General LCD positioning defines */
#define TOP_ROW				(0)
#define BOTTOM_ROW			(1)
#define ROW_START			(0)

/*
Human-friendly names for the custom chars, defined in LCD_CustChars.c
*/

/* CHAR_LO - used by the scope demo to indicate a low signal */
#define CHAR_LO				LCD_CUSTOM_0

/* CHAR_HI - used by the scope demo to indicate a high signal */
#define CHAR_HI				LCD_CUSTOM_1

/* CHAR_RISE - used by the scope demo to indicate a rising signal */
#define CHAR_RISE			LCD_CUSTOM_2

/* CHAR_FALL - used by the scope demo to indicate a falling signal */
#define CHAR_FALL			LCD_CUSTOM_3

/* CHAR_SINEH - unused placeholder - high phase of a sine wave */
#define CHAR_SINEH			LCD_CUSTOM_4

/* CHAR_SINEL - unused placeholder - low phase of a sine wave */
#define CHAR_SINEL			LCD_CUSTOM_5

/* CHAR_MU - Greek mu symbol */
#define CHAR_MU				LCD_CUSTOM_6

/* CHAR_HEART - used by MainTask to print a cute heart shape */
#define CHAR_HEART			LCD_CUSTOM_7

#define NUM_DEMOS           (5)
#define MAX_DEMO            (NUM_DEMOS-1)
#define MIN_DEMO            (0)

/*
CapSense defines
*/

/* Returned from CapSense APIs when there is no activity */
#define NO_FINGER           (0xFFFF)

/* RealView MDK requires the following pragma to allow anonymous unions */
#ifdef __ARMCC_VERSION
#pragma anon_unions
#endif

/* Type definition for CapSense results. CS_PACKET is a 32-bit structure
   that can be accessed as a whole 32-bit value or four 8-bit fields */
typedef union
{
	/* 32-bit quantity returned from the CapSense_Monitor_Q */
	uint32 result;
	
	/* The same data interpreted as 8-bit values */
	struct
	{
		uint8 b0;			/* 1 = Button 0 presed */
		uint8 b1;			/* 1 = Button 1 pressed */
		uint8 slider;		/* 1 = Finger on slider */
		uint8 sliderval;	/* Slider value if slider==1 */
	};
} CS_PACKET;


/*
Digital_Scope_Demo defines
*/

/* Defines for SW2 switch state */
#define LO                  (0)
#define HI                  (1)

/* Defines to control the scope speed */
#define SCOPE_DELAY_MIN     (100)
#define SCOPE_DELAY_MAX     (400)
#define SCOPE_DELAY_DEFAULT ( ( ( SCOPE_DELAY_MAX - SCOPE_DELAY_MIN ) / 2 ) + SCOPE_DELAY_MIN )
#define SCOPE_DELAY_UNITS   ( ( SCOPE_DELAY_MAX - SCOPE_DELAY_MIN ) / 100 )
