/*******************************************************************************
* File Name: Comp_2_VRef_PM.c  
* Version 1.90
*
* Description:
*  This file provides the power management source code to API for the
*  VDAC8.  
*
* Note:
*  None
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "Comp_2_VRef.h"

static Comp_2_VRef_backupStruct Comp_2_VRef_backup;


/*******************************************************************************
* Function Name: Comp_2_VRef_SaveConfig
********************************************************************************
* Summary:
*  Save the current user configuration
*
* Parameters:  
*  void  
*
* Return: 
*  void
*
*******************************************************************************/
void Comp_2_VRef_SaveConfig(void) 
{
    if (!((Comp_2_VRef_CR1 & Comp_2_VRef_SRC_MASK) == Comp_2_VRef_SRC_UDB))
    {
        Comp_2_VRef_backup.data_value = Comp_2_VRef_Data;
    }
}


/*******************************************************************************
* Function Name: Comp_2_VRef_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the current user configuration.
*
* Parameters:  
*  void
*
* Return: 
*  void
*
*******************************************************************************/
void Comp_2_VRef_RestoreConfig(void) 
{
    if (!((Comp_2_VRef_CR1 & Comp_2_VRef_SRC_MASK) == Comp_2_VRef_SRC_UDB))
    {
        if((Comp_2_VRef_Strobe & Comp_2_VRef_STRB_MASK) == Comp_2_VRef_STRB_EN)
        {
            Comp_2_VRef_Strobe &= (uint8)(~Comp_2_VRef_STRB_MASK);
            Comp_2_VRef_Data = Comp_2_VRef_backup.data_value;
            Comp_2_VRef_Strobe |= Comp_2_VRef_STRB_EN;
        }
        else
        {
            Comp_2_VRef_Data = Comp_2_VRef_backup.data_value;
        }
    }
}


/*******************************************************************************
* Function Name: Comp_2_VRef_Sleep
********************************************************************************
* Summary:
*  Stop and Save the user configuration
*
* Parameters:  
*  void:  
*
* Return: 
*  void
*
* Global variables:
*  Comp_2_VRef_backup.enableState:  Is modified depending on the enable 
*  state  of the block before entering sleep mode.
*
*******************************************************************************/
void Comp_2_VRef_Sleep(void) 
{
    /* Save VDAC8's enable state */    
    if(Comp_2_VRef_ACT_PWR_EN == (Comp_2_VRef_PWRMGR & Comp_2_VRef_ACT_PWR_EN))
    {
        /* VDAC8 is enabled */
        Comp_2_VRef_backup.enableState = 1u;
    }
    else
    {
        /* VDAC8 is disabled */
        Comp_2_VRef_backup.enableState = 0u;
    }
    
    Comp_2_VRef_Stop();
    Comp_2_VRef_SaveConfig();
}


/*******************************************************************************
* Function Name: Comp_2_VRef_Wakeup
********************************************************************************
*
* Summary:
*  Restores and enables the user configuration
*  
* Parameters:  
*  void
*
* Return: 
*  void
*
* Global variables:
*  Comp_2_VRef_backup.enableState:  Is used to restore the enable state of 
*  block on wakeup from sleep mode.
*
*******************************************************************************/
void Comp_2_VRef_Wakeup(void) 
{
    Comp_2_VRef_RestoreConfig();
    
    if(Comp_2_VRef_backup.enableState == 1u)
    {
        /* Enable VDAC8's operation */
        Comp_2_VRef_Enable();

        /* Restore the data register */
        Comp_2_VRef_SetValue(Comp_2_VRef_Data);
    } /* Do nothing if VDAC8 was disabled before */    
}


/* [] END OF FILE */
