/* =============================================================================
 *
 * Digital_Scope_Demo.c
 *
 * This file contains the code for the digital scope demo task.
 *
 * v1.0	YFS	Initial release. 
 *
 * =============================================================================
*/

/*
* Copyright (2014), Cypress Semiconductor Corporation. All Rights Reserved.
*
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH 
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the 
* materials described herein. Cypress does not assume any liability arising out 
* of the application or use of any product or circuit described herein. Cypress 
* does not authorize its products for use as critical components in life-support 
* systems where a malfunction or failure may reasonably be expected to result in 
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of 
* such use and in doing so indemnifies Cypress against all charges. 
*
* Use of this Software may be limited by and subject to the applicable Cypress
* software license agreement. 
*/

/* Include FreeRTOS APIs and defines */
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>

/* Include PSoC system and component APIs and defines */
#include <project.h>

/* Include application function declarations and defines */
#include <utils.h>
#include <App_Defs.h>
#include <Task_Defs.h>

char next_char = 'X'; /* next character to display */

/*
 * Function:		Reader_Task
 *
 * Globals:		Uses Demo_Events, Main_Task_Event and CapSense_Monitor_Q
 *
 * Parameters:	pvParameters (demo index number)
 *
 * Return:		None (infinite loop)
 */
 
void Reader_Task( void *pvParameters )
{
	int demoNumber = (int)pvParameters;     /* Passed from xTaskCreate */
    
    BaseType_t queueDataReceived;           /* Return from queue API */
	
	int LCD_update_delay = SCOPE_DELAY_DEFAULT;	/* Time between LCD updates */
	
	CS_PACKET capsensepacket;	/* Hold a message from CapSense Q */
	
    int state = LO;				/* Start by assuming button is not pressed */

	int pressed;				/* Use this to flag the switch being pressed */
    
	
	/*
	Prepare the LCD to show the demo results.
	*/
	LCD_ClearDisplay();
	LCD_PrintString( READER_TASK );
	
	CyDelay( 250 );	/* Debounce (250ms) button press  */
	
	/* Give the user some instructions */
    /*
	scroll( 1, "Apply signal via SW2." );
    */
	
    for( ; ; )		/* Demo main loop (forever) */
    {
		/* Collect the CapSense activity from the message queue */
        queueDataReceived = xQueueReceive(
            CapSense_Monitor_Q,
            &capsensepacket.result,
            DO_NOT_WAIT_ON_QUEUE );
        
        if( queueDataReceived == pdTRUE )
        {
            /* Calculate new update rate from the slider value */
				if( capsensepacket.slider )
				{
					/* Delay is between 100 and 400 (100+3*100) ms */
					LCD_update_delay = SCOPE_DELAY_MIN + 
								capsensepacket.sliderval * SCOPE_DELAY_UNITS;
				}
				/* Note: Buttons presses are ignored */            
        }

        /* Read SW2 - reverse the logic (!) so pressed (grounded) means HI */
		pressed = ! P6_1_Read();
		
		/* Pick the character that represents the state of the signal */
        if( !pressed && state==LO )
		{
			next_char = CHAR_LO;		/* Signal is low and stays low */
		}
		else if( pressed && state==HI )
		{
			next_char = CHAR_HI;		/* Signal is high and stays high */
		}		
		else if( pressed && state==LO )
		{
			next_char = CHAR_RISE;		/* Signal is low and goes high */
			state = HI;						/* New state */
		}
		else if( !pressed && state==HI )
		{
			next_char = CHAR_FALL;		/* Signal is high and goes low */
			state = LO;						/* New state */
		}
		
        /* delay yourself so that Writer_Task() can run. Delay interval depends on capsense slider. */
        vTaskDelay(LCD_update_delay);
    } /* for( ; ; ) */
	
} /* Reader_Task() */

void Writer_Task( void *pvParameters )
{
	int demoNumber = (int)pvParameters;     /* Passed from xTaskCreate */
    
    BaseType_t queueDataReceived;           /* Return from queue API */

    int LCD_update_delay = SCOPE_DELAY_DEFAULT;	/* Time between LCD updates */
	
	CS_PACKET capsensepacket;	/* Hold a message from CapSense Q */
	

    LCD_ClearDisplay();
	LCD_PrintString( WRITER_TASK );
    
	/* Declare the buffer, its index and a loop counter to clear/print it */
	char buffer[LCD_WIDTH];
	int index = 0;
	int i;
	
	/* Clear the buffer - set all chars to '_' */
	for( i=0; i<LCD_WIDTH; i++ )
	{
		buffer[i] = '_';
	}
	
    for( ; ; )		/* Demo main loop (forever) */
    {
		/* Collect the CapSense activity from the message queue */
        queueDataReceived = xQueueReceive(
            CapSense_Monitor_Q,
            &capsensepacket.result,
            DO_NOT_WAIT_ON_QUEUE );
        
        if( queueDataReceived == pdTRUE )
        {
            /* Calculate new update rate from the slider value */
				if( capsensepacket.slider )
				{
					/* Delay is between 100 and 400 (100+3*100) ms */
					LCD_update_delay = SCOPE_DELAY_MIN + 
								capsensepacket.sliderval * SCOPE_DELAY_UNITS;
				}
				/* Note: Buttons presses are ignored */            
        }
        
        /* update the buffer */
        for (i=LCD_WIDTH-2; i>=0; i--)
        {
                buffer[i] = buffer[i+1];
        }
        buffer[LCD_WIDTH-1] = next_char;
		
		/*
		Print out the buffer, oldest char first, so movement is R-to-L.
		
		*/
		
		/* Next print out the LCD_WIDTH chars */
		LCD_Position( 1, 0 );
		for( i=0; i<LCD_WIDTH; i++ )
		{
			LCD_PutChar( buffer[i] );
		}
		
        /* delay yourself so that Reader_Task() can run. Delay interval depends on capsense slider. */
        vTaskDelay(LCD_update_delay);
		
    } /* for( ; ; ) */
	
} /* Writer_Task() */