/* =============================================================================
 *
 * Main_Task.c
 *
 * This file contains the start function for Main_Task.
 *
 * v1.0	YFS		Initial release.
 *
 * =============================================================================
*/

/*
* Copyright (2013), Cypress Semiconductor Corporation. All Rights Reserved.
*
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH 
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the 
* materials described herein. Cypress does not assume any liability arising out 
* of the application or use of any product or circuit described herein. Cypress 
* does not authorize its products for use as critical components in life-support 
* systems where a malfunction or failure may reasonably be expected to result in 
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of 
* such use and in doing so indemnifies Cypress against all charges. 
*
* Use of this Software may be limited by and subject to the applicable Cypress
* software license agreement. 
*/

/* Include FreeRTOS APIs and defines */
#include "FreeRTOS.h"
#include "task.h"

/* Include PSoC system and component APIs and defines */
#include <project.h>

/* Include application function declarations and defines */
#include <Task_Defs.h>

/*
 * Function:		Main_Task
 *
 * This function runs as a FreeRTOS task with a middle priority.
 * It toggles LED3 on/off once a second.
 *
 *			Start task
 *			Set LED3 to be under software control
 *		 -> Toggle LED3
 *		|	Delay one second
 *		 -- Loop
 * 
 * Globals:		Uses configTICK_RATE_HZ to create 0.5Hz LED flash rate
 *
 * Parameters:	pvParameters (not used)
 *
 * Return:		None (infinite loop)
 */
void Main_Task( void *pvParameters )
{   
	/* Init the LED controller - enable software control */
	LED3_Control_Set_Channel( LED3_Control_USE_SOFTWARE );

	for( ; ; )
	{
		/* Delay 1s */
        vTaskDelay( configTICK_RATE_HZ );
		
		/* Toggle the LED3 on/off - creates a 0.5Hz frequency */
		LED3_Control_Write( ! LED3_Control_Read() );
			
	} /* for( ; ; ) */
	
} /* Main_Task */
