/********************************************************************************
* File Name: main.c
*
* Version : 1.00
*
* Description: 
*  This is a source code for example project of 16 bit Timer UDB Block.
*
* Test Result:
*  Watch capture output on P0_0, tc output on P0_1, and Period, Compare and 
*  Count value on LCD.
*
********************************************************************************
* Copyright 2012, Cypress Semiconductor Corporation. All rights reserved.
* This software is owned by Cypress Semiconductor Corporation and is protected
* by and subject to worldwide patent and copyright laws and treaties.
* Therefore, you may use this software only as provided in the license agreement
* accompanying the software package from which you obtained this software.
* CYPRESS AND ITS SUPPLIERS MAKE NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* WITH REGARD TO THIS SOFTWARE, INCLUDING, BUT NOT LIMITED TO, NONINFRINGEMENT,
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*******************************************************************************/
#include <device.h>

uint8 InterruptCnt;
uint8 heartbeat = 0; /* state of the heartbeat output pin */
int idelay, NDELAY=1000, scum;


/*******************************************************************************
* Define Interrupt service routine and allocate an vector to the Interrupt
********************************************************************************/
CY_ISR(InterruptHandler)
{
	/* Read Status register in order to clear the sticky Terminal Count (TC) bit 
	 * in the status register. Note that the function is not called, but rather 
	 * the status is read directly.
	 */
   	Timer_1_STATUS;
    
	/* Increment the Counter to indicate the keep track of the number of 
     * interrupts received */
    InterruptCnt++;

    /* update the heartbeat*/
    heartbeat = ~heartbeat;
    heartbeat_Write(heartbeat);
#if 0
    for (idelay=0, scum=0; idelay<NDELAY; idelay++) scum = scum+1;
#endif
}

CY_ISR(Timer_2_Handler)
{
    /*  Place your Interrupt code here. */
    /* `#START Timer_2_ISR_Interrupt` */
   	Timer_2_STATUS;
    

    h2_Write(!heartbeat);
#if 1
    for (idelay=0, scum=0; idelay<NDELAY; idelay++) scum = scum+1;
#endif
    /* `#END` */
}


/*******************************************************************************
* Function Name: main
********************************************************************************
*
* Summary:
* Main function performs following functions:
* 1: Enables the clock
* 2: Start the Timer
* 3: Initializes the LCD
* 4: Print Period, capture, counter value on LCD
* 
* Parameters:
*  None.
*
* Return:
*  None.
*
*******************************************************************************/
void main()
{   
    /* Enable the global interrupt */
    CyGlobalIntEnable;
    
    /* Enable the Interrupt component connected to Timer interrupt */
    TimerISR_StartEx(InterruptHandler);
    Timer_2_ISR_StartEx(Timer_2_Handler);

	/* Start the components */
    Timer_1_Start();
    Timer_2_Start();


    /* Display TMR-16 on LCD */
    LCD_Start();
    LCD_Position(0u, 0u);
    LCD_PrintString("Heart");

    for(;;)
    {
        /* To display Period on LCD */
        LCD_Position(0u, 7u);
        LCD_PrintInt16(Timer_1_ReadPeriod());
        LCD_Position(0u, 12u);
        LCD_PrintInt16(Timer_2_ReadPeriod());


        /* To display count on LCD */
        LCD_Position(1u, 0u);
        LCD_PrintInt16(Timer_1_ReadCounter()-Timer_2_ReadCounter());

        /* To display Interrupt count on LCD */
        LCD_Position(1u, 5u);
        LCD_PrintString("IntCnt:");
        LCD_PrintInt16(InterruptCnt);
		
		CyDelay(1u);
    }
}


/* [] END OF FILE */
