/*******************************************************************************
* File Name: Comp_1_VRef_PM.c  
* Version 1.90
*
* Description:
*  This file provides the power management source code to API for the
*  VDAC8.  
*
* Note:
*  None
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include "Comp_1_VRef.h"

static Comp_1_VRef_backupStruct Comp_1_VRef_backup;


/*******************************************************************************
* Function Name: Comp_1_VRef_SaveConfig
********************************************************************************
* Summary:
*  Save the current user configuration
*
* Parameters:  
*  void  
*
* Return: 
*  void
*
*******************************************************************************/
void Comp_1_VRef_SaveConfig(void) 
{
    if (!((Comp_1_VRef_CR1 & Comp_1_VRef_SRC_MASK) == Comp_1_VRef_SRC_UDB))
    {
        Comp_1_VRef_backup.data_value = Comp_1_VRef_Data;
    }
}


/*******************************************************************************
* Function Name: Comp_1_VRef_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the current user configuration.
*
* Parameters:  
*  void
*
* Return: 
*  void
*
*******************************************************************************/
void Comp_1_VRef_RestoreConfig(void) 
{
    if (!((Comp_1_VRef_CR1 & Comp_1_VRef_SRC_MASK) == Comp_1_VRef_SRC_UDB))
    {
        if((Comp_1_VRef_Strobe & Comp_1_VRef_STRB_MASK) == Comp_1_VRef_STRB_EN)
        {
            Comp_1_VRef_Strobe &= (uint8)(~Comp_1_VRef_STRB_MASK);
            Comp_1_VRef_Data = Comp_1_VRef_backup.data_value;
            Comp_1_VRef_Strobe |= Comp_1_VRef_STRB_EN;
        }
        else
        {
            Comp_1_VRef_Data = Comp_1_VRef_backup.data_value;
        }
    }
}


/*******************************************************************************
* Function Name: Comp_1_VRef_Sleep
********************************************************************************
* Summary:
*  Stop and Save the user configuration
*
* Parameters:  
*  void:  
*
* Return: 
*  void
*
* Global variables:
*  Comp_1_VRef_backup.enableState:  Is modified depending on the enable 
*  state  of the block before entering sleep mode.
*
*******************************************************************************/
void Comp_1_VRef_Sleep(void) 
{
    /* Save VDAC8's enable state */    
    if(Comp_1_VRef_ACT_PWR_EN == (Comp_1_VRef_PWRMGR & Comp_1_VRef_ACT_PWR_EN))
    {
        /* VDAC8 is enabled */
        Comp_1_VRef_backup.enableState = 1u;
    }
    else
    {
        /* VDAC8 is disabled */
        Comp_1_VRef_backup.enableState = 0u;
    }
    
    Comp_1_VRef_Stop();
    Comp_1_VRef_SaveConfig();
}


/*******************************************************************************
* Function Name: Comp_1_VRef_Wakeup
********************************************************************************
*
* Summary:
*  Restores and enables the user configuration
*  
* Parameters:  
*  void
*
* Return: 
*  void
*
* Global variables:
*  Comp_1_VRef_backup.enableState:  Is used to restore the enable state of 
*  block on wakeup from sleep mode.
*
*******************************************************************************/
void Comp_1_VRef_Wakeup(void) 
{
    Comp_1_VRef_RestoreConfig();
    
    if(Comp_1_VRef_backup.enableState == 1u)
    {
        /* Enable VDAC8's operation */
        Comp_1_VRef_Enable();

        /* Restore the data register */
        Comp_1_VRef_SetValue(Comp_1_VRef_Data);
    } /* Do nothing if VDAC8 was disabled before */    
}


/* [] END OF FILE */
