/*******************************************************************************
* File Name: LED4_Control.h
*
* Version 1.00
*
* Description:
* This file contains the LED_Control API declarations and the Control
* Register define.
*
********************************************************************************
* Copyright 2008-2013, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#if !defined(LED4_Control_H)
#define LED4_Control_H

/* LED_Control_Channel type definitions */
#define LED4_Control__SOFTWARE 0
#define LED4_Control__IN1_AND_IN2 3
#define LED4_Control__IN1_XOR_IN2 4
#define LED4_Control__IN1 1
#define LED4_Control__IN2 2


/* Definitions of control register meanings */
#define LED4_Control_SOFTWARE_BIT		(3)
#define LED4_Control_SOFTWARE_MASK		(1<<LED4_Control_SOFTWARE_BIT)

/* Definitions of MUX channels */
#define LED4_Control_USE_SOFTWARE		(LED4_Control__SOFTWARE)
#define LED4_Control_USE_IN1			(LED4_Control__IN1)
#define LED4_Control_USE_IN2			(LED4_Control__IN2)
#define LED4_Control_USE_IN1_AND_IN2	(LED4_Control__IN1_AND_IN2)
#define LED4_Control_USE_IN1_XOR_IN2	(LED4_Control__IN1_XOR_IN2)
#define LED4_Control_USE_MASK			(7)


/***************************************
*         Function Prototypes 
***************************************/

/* Chooses the signal to be routed to the output/LED */
void LED4_Control_Set_Channel( int use );

/* Returns the selected output/LED */
int LED4_Control_Get_Channel( void );

/* Writes to the output/LED when it is driven from software */
void LED4_Control_Write( int value );

/* Returns the state of the output when it is driven from software */
int	LED4_Control_Read(void);


/***************************************
*            Registers        
***************************************/

/* Control Register */
#define LED4_Control_LED_Reg_Control \
		(* (reg8 *)LED4_Control_LED_Reg_Sync_ctrl_reg__CONTROL_REG)

#endif
