/* =============================================================================
 *
 * Task_Defs.h
 *
 * This file contains forward references for all tasks and resources.
 * It also defines useful macros for FreeRTOS APIs.
 * 
 * v1.0	YFS	Initial release.
 *
 * =============================================================================
*/

/*
* Copyright (2014), Cypress Semiconductor Corporation. All Rights Reserved.
*
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH 
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the 
* materials described herein. Cypress does not assume any liability arising out 
* of the application or use of any product or circuit described herein. Cypress 
* does not authorize its products for use as critical components in life-support 
* systems where a malfunction or failure may reasonably be expected to result in 
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of 
* such use and in doing so indemnifies Cypress against all charges. 
*
* Use of this Software may be limited by and subject to the applicable Cypress
* software license agreement. 
*/

/*
Forward definitions of global resources
*/
extern QueueHandle_t CapSense_Monitor_Q;        /* CapSense queue */
extern EventGroupHandle_t Demo_Events;          /* Event group for all demos */
extern EventGroupHandle_t Main_Task_Event;      /* Event group for Main_Task */

/*
Useful defines for global resources
*/

/* Event group bit for Main_Task_Event */
#define MAIN_TASK_EVENT_NUM                 (1)

/* Size of the CapSense queue */
#define CAPSENSE_MONITOR_Q_SIZE		        (5)

/* Force queueDataReceived() to be non-blocking */
#define DO_NOT_WAIT_ON_QUEUE                (0)

/* Force xEventGroupWaitBits() to never timeout */
#define WAIT_FOREVER                        (portMAX_DELAY)

/*
Forward definitions of all task start functions
*/
void Main_Task( void * );                   /* Starts demos and runs the menus */
void Reader_Task( void * );       /* Reads user input */
void Writer_Task( void * );        /* Displays user input */


/*
Useful defines for all tasks
 - No arguments are passed when the task is created
 - The task handle (created in xTaskCreate) is not required
*/
#define NO_TASK_ARG						    ((void *)0)
#define TASK_HANDLE_UNUSED				    ((void *)0)

/*
Useful defines for demo tasks
 - Stack size = 256 bytes (more than enough for these demo tasks)
 - priority ~= middle priority
*/
#define DEMO_TASK_STACK_SIZE	            (256)
#define DEMO_TASK_PRIORITY				    ( configMAX_PRIORITIES / 2 )

/*
xTaskCreate arguments for all tasks
- name
- priority
- stack size
*/

/* Note: the following tasks use the "DEMO" priority and stack sizes */
#define READER_TASK				            ( "Reader" )
#define WRITER_TASK				            ( "Writer" )


/* Main task with middle priority and same stack size as demos */
#define MAIN_TASK				            ( "Main" )
#define MAIN_TASK_PRIORITY		            ( DEMO_TASK_PRIORITY - 1 )
#define MAIN_TASK_STACK_SIZE	            ( DEMO_TASK_STACK_SIZE )

/* CapSense task with high priority and same stack size as demos */
#define CAPSENSE_MONITOR_TASK				( "CapSense Mon" )
#define CAPSENSE_MONITOR_TASK_PRIORITY		( DEMO_TASK_PRIORITY + 1 )
#define CAPSENSE_MONITOR_TASK_STACK_SIZE	( DEMO_TASK_STACK_SIZE )
