/*******************************************************************************
* File Name: Comp_3_Low_ISR.h
* Version 1.70
*
*  Description:
*   Provides the function definitions for the Interrupt Controller.
*
*
********************************************************************************
* Copyright 2008-2012, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/
#if !defined(CY_ISR_Comp_3_Low_ISR_H)
#define CY_ISR_Comp_3_Low_ISR_H


#include <cytypes.h>
#include <cyfitter.h>

/* Interrupt Controller API. */
void Comp_3_Low_ISR_Start(void);
void Comp_3_Low_ISR_StartEx(cyisraddress address);
void Comp_3_Low_ISR_Stop(void);

CY_ISR_PROTO(Comp_3_Low_ISR_Interrupt);

void Comp_3_Low_ISR_SetVector(cyisraddress address);
cyisraddress Comp_3_Low_ISR_GetVector(void);

void Comp_3_Low_ISR_SetPriority(uint8 priority);
uint8 Comp_3_Low_ISR_GetPriority(void);

void Comp_3_Low_ISR_Enable(void);
uint8 Comp_3_Low_ISR_GetState(void);
void Comp_3_Low_ISR_Disable(void);

void Comp_3_Low_ISR_SetPending(void);
void Comp_3_Low_ISR_ClearPending(void);


/* Interrupt Controller Constants */

/* Address of the INTC.VECT[x] register that contains the Address of the Comp_3_Low_ISR ISR. */
#define Comp_3_Low_ISR_INTC_VECTOR            ((reg32 *) Comp_3_Low_ISR__INTC_VECT)

/* Address of the Comp_3_Low_ISR ISR priority. */
#define Comp_3_Low_ISR_INTC_PRIOR             ((reg8 *) Comp_3_Low_ISR__INTC_PRIOR_REG)

/* Priority of the Comp_3_Low_ISR interrupt. */
#define Comp_3_Low_ISR_INTC_PRIOR_NUMBER      Comp_3_Low_ISR__INTC_PRIOR_NUM

/* Address of the INTC.SET_EN[x] byte to bit enable Comp_3_Low_ISR interrupt. */
#define Comp_3_Low_ISR_INTC_SET_EN            ((reg32 *) Comp_3_Low_ISR__INTC_SET_EN_REG)

/* Address of the INTC.CLR_EN[x] register to bit clear the Comp_3_Low_ISR interrupt. */
#define Comp_3_Low_ISR_INTC_CLR_EN            ((reg32 *) Comp_3_Low_ISR__INTC_CLR_EN_REG)

/* Address of the INTC.SET_PD[x] register to set the Comp_3_Low_ISR interrupt state to pending. */
#define Comp_3_Low_ISR_INTC_SET_PD            ((reg32 *) Comp_3_Low_ISR__INTC_SET_PD_REG)

/* Address of the INTC.CLR_PD[x] register to clear the Comp_3_Low_ISR interrupt. */
#define Comp_3_Low_ISR_INTC_CLR_PD            ((reg32 *) Comp_3_Low_ISR__INTC_CLR_PD_REG)


#endif /* CY_ISR_Comp_3_Low_ISR_H */


/* [] END OF FILE */
