/*******************************************************************************
* File Name: LED4_Control.c
*
* Version 1.00
*
* Description:
* This file contains the LED_Control API definitions. The application can
* choose, via a control register (LED4_Control_LED_Reg_Control),
* whether to drive the output from HW (schematic file) or SW (API call).
*
********************************************************************************
* Copyright 2008-2013, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions, 
* disclaimers, and limitations in the end user license agreement accompanying 
* the software package with which this file was provided.
*******************************************************************************/

#include <project.h>
#include <LED4_Control.h>

/*
 * void LED4_Control_Set_Channel( int use )
 *
 * Chooses which signal to route to the output/LED.
 *
 * Reads the register, modifies the bits that control the signal
 * selection, and writes the new value back to the register.
 *
 * Parameters:
 *	use:	The signal to be routed (LED4_Control_USE_*)
 *
 * 	Return:	void
*/
void LED4_Control_Set_Channel( int use )
{
	uint8 regval = LED4_Control_LED_Reg_Control;
	
	/* Clear the bits that determine use and patch in the new value */
	regval &= ~LED4_Control_USE_MASK;
	regval |= (uint8) use;
	
	/* Change the channel */
	LED4_Control_LED_Reg_Control = regval;
	
} /* LED4_Control_Set_Channel */


/*
 * int LED4_Control_Get_Channel( void )
 *
 * Returns the value of the software bit in the control register.
 * If the output is driven from the schematic the return value is undefined.
 *
 * Parameters:	None
 *
 * 	Return:		int
*/
int LED4_Control_Get_Channel( void )
{
	return ( LED4_Control_LED_Reg_Control & LED4_Control_USE_MASK );
} /* LED4_Control_Get_Channel */


/*
 * void LED4_Control_Write( int value )
 *
 * Writes to the LED when it is driven from software.
 *
 * Reads the register and checks that the selected output is software-driven.
 * If so, it updates the bit that drives the output based on the function argument.
 *
 * If the output is driven from the schematic this API has no effect.
 *
 * Parameters:
 *	value:	0 (OFF) or non-zero (ON)
 *
 * 	Return:	void
*/
void LED4_Control_Write( int value )
{
	uint8 regval = LED4_Control_LED_Reg_Control;
	
	if( ( regval & LED4_Control_USE_MASK ) == LED4_Control_USE_SOFTWARE )
	{
		/* Patch bit LED4_Control_SOFTWARE_MASK depending upon value */
		if( value )
		{
			/* Set output to 1 */
			regval |= LED4_Control_SOFTWARE_MASK;
		}
		else
		{
			/* Clear the output */
			regval &= ~LED4_Control_SOFTWARE_MASK;
		}
	
		LED4_Control_LED_Reg_Control = regval;
	} /* if( reg & LED4_Control_USE_MASK == LED4_Control_USE_SOFTWARE ) */
} /* LED4_Control_Write */


/*
 * int LED4_Control_Read( void )
 *
 * Returns the value of the software bit in the control register.
 * If the output is driven from the schematic the return value is undefined.
 *
 * Parameters:	None
 *
 * 	Return:		0 (OFF) or 1 (ON)
*/
int LED4_Control_Read( void )
{
	return ( LED4_Control_LED_Reg_Control & LED4_Control_SOFTWARE_MASK ) ? 1 : 0;
} /* LED4_Control_Read */
