/*******************************************************************************
* File Name: Timer_1MHz_PM.c
* Version 2.70
*
*  Description:
*     This file provides the power management source code to API for the
*     Timer.
*
*   Note:
*     None
*
*******************************************************************************
* Copyright 2008-2014, Cypress Semiconductor Corporation.  All rights reserved.
* You may use this file only in accordance with the license, terms, conditions,
* disclaimers, and limitations in the end user license agreement accompanying
* the software package with which this file was provided.
********************************************************************************/

#include "Timer_1MHz.h"

static Timer_1MHz_backupStruct Timer_1MHz_backup;


/*******************************************************************************
* Function Name: Timer_1MHz_SaveConfig
********************************************************************************
*
* Summary:
*     Save the current user configuration
*
* Parameters:
*  void
*
* Return:
*  void
*
* Global variables:
*  Timer_1MHz_backup:  Variables of this global structure are modified to
*  store the values of non retention configuration registers when Sleep() API is
*  called.
*
*******************************************************************************/
void Timer_1MHz_SaveConfig(void) 
{
    #if (!Timer_1MHz_UsingFixedFunction)
        Timer_1MHz_backup.TimerUdb = Timer_1MHz_ReadCounter();
        Timer_1MHz_backup.InterruptMaskValue = Timer_1MHz_STATUS_MASK;
        #if (Timer_1MHz_UsingHWCaptureCounter)
            Timer_1MHz_backup.TimerCaptureCounter = Timer_1MHz_ReadCaptureCount();
        #endif /* Back Up capture counter register  */

        #if(!Timer_1MHz_UDB_CONTROL_REG_REMOVED)
            Timer_1MHz_backup.TimerControlRegister = Timer_1MHz_ReadControlRegister();
        #endif /* Backup the enable state of the Timer component */
    #endif /* Backup non retention registers in UDB implementation. All fixed function registers are retention */
}


/*******************************************************************************
* Function Name: Timer_1MHz_RestoreConfig
********************************************************************************
*
* Summary:
*  Restores the current user configuration.
*
* Parameters:
*  void
*
* Return:
*  void
*
* Global variables:
*  Timer_1MHz_backup:  Variables of this global structure are used to
*  restore the values of non retention registers on wakeup from sleep mode.
*
*******************************************************************************/
void Timer_1MHz_RestoreConfig(void) 
{   
    #if (!Timer_1MHz_UsingFixedFunction)

        Timer_1MHz_WriteCounter(Timer_1MHz_backup.TimerUdb);
        Timer_1MHz_STATUS_MASK =Timer_1MHz_backup.InterruptMaskValue;
        #if (Timer_1MHz_UsingHWCaptureCounter)
            Timer_1MHz_SetCaptureCount(Timer_1MHz_backup.TimerCaptureCounter);
        #endif /* Restore Capture counter register*/

        #if(!Timer_1MHz_UDB_CONTROL_REG_REMOVED)
            Timer_1MHz_WriteControlRegister(Timer_1MHz_backup.TimerControlRegister);
        #endif /* Restore the enable state of the Timer component */
    #endif /* Restore non retention registers in the UDB implementation only */
}


/*******************************************************************************
* Function Name: Timer_1MHz_Sleep
********************************************************************************
*
* Summary:
*     Stop and Save the user configuration
*
* Parameters:
*  void
*
* Return:
*  void
*
* Global variables:
*  Timer_1MHz_backup.TimerEnableState:  Is modified depending on the
*  enable state of the block before entering sleep mode.
*
*******************************************************************************/
void Timer_1MHz_Sleep(void) 
{
    #if(!Timer_1MHz_UDB_CONTROL_REG_REMOVED)
        /* Save Counter's enable state */
        if(Timer_1MHz_CTRL_ENABLE == (Timer_1MHz_CONTROL & Timer_1MHz_CTRL_ENABLE))
        {
            /* Timer is enabled */
            Timer_1MHz_backup.TimerEnableState = 1u;
        }
        else
        {
            /* Timer is disabled */
            Timer_1MHz_backup.TimerEnableState = 0u;
        }
    #endif /* Back up enable state from the Timer control register */
    Timer_1MHz_Stop();
    Timer_1MHz_SaveConfig();
}


/*******************************************************************************
* Function Name: Timer_1MHz_Wakeup
********************************************************************************
*
* Summary:
*  Restores and enables the user configuration
*
* Parameters:
*  void
*
* Return:
*  void
*
* Global variables:
*  Timer_1MHz_backup.enableState:  Is used to restore the enable state of
*  block on wakeup from sleep mode.
*
*******************************************************************************/
void Timer_1MHz_Wakeup(void) 
{
    Timer_1MHz_RestoreConfig();
    #if(!Timer_1MHz_UDB_CONTROL_REG_REMOVED)
        if(Timer_1MHz_backup.TimerEnableState == 1u)
        {     /* Enable Timer's operation */
                Timer_1MHz_Enable();
        } /* Do nothing if Timer was disabled before */
    #endif /* Remove this code section if Control register is removed */
}


/* [] END OF FILE */
